/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.ranged;

import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.IRangedWeaponGoal;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public abstract class GolemRangedAttackGoal
extends Goal
implements IRangedWeaponGoal {
    protected final HumanoidGolemEntity mob;
    protected final GolemMeleeGoal melee;
    protected final double speedModifier;
    protected final double radius;
    protected int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int meleeTime = 0;

    protected GolemRangedAttackGoal(HumanoidGolemEntity mob, GolemMeleeGoal melee, double speedModifier, double r) {
        this.mob = mob;
        this.melee = melee;
        this.speedModifier = speedModifier;
        this.radius = r;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) {
            return false;
        }
        ItemStack stack = this.mob.m_21120_(this.mob.getWeaponHand());
        return this.mayActivate(this.mob, stack);
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.mob.setInRangeAttack(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.setInRangeAttack(false);
        this.seeTime = 0;
        this.meleeTime = 0;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    protected void doMelee() {
        if (this.meleeTime > 0) {
            --this.meleeTime;
            return;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        if (this.melee.canReachTarget(target)) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
            this.meleeTime = this.melee.m_183277_(20);
        }
    }

    @Override
    public double range(HumanoidGolemEntity golem, ItemStack stack) {
        return this.radius(stack);
    }

    protected double radius(ItemStack stack) {
        return this.radius;
    }

    public final double attackRadiusSqr() {
        ItemStack stack = this.mob.m_21120_(this.mob.getWeaponHand());
        return this.radius(stack) * this.radius(stack);
    }

    protected void strafing() {
        boolean oldSight;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double dist = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean sight = this.mob.m_21574_().m_148306_((Entity)target);
        boolean bl = oldSight = this.seeTime > 0;
        if (sight != oldSight) {
            this.seeTime = 0;
        }
        this.seeTime = sight ? ++this.seeTime : --this.seeTime;
        double sqr = this.attackRadiusSqr();
        if (dist <= sqr && this.seeTime >= 20) {
            this.mob.m_21573_().m_26573_();
            ++this.strafingTime;
        } else {
            this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
            this.strafingTime = -1;
        }
        if (sqr < 15.0) {
            this.strafingTime = 0;
            return;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (dist > sqr * 0.75) {
                this.strafingBackwards = false;
            } else if (dist < sqr * 0.25) {
                this.strafingBackwards = true;
            }
            this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
    }
}

